/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import cc.tweaked.cobalt.internal.doubles.DoubleToStringConverter;
import cc.tweaked.cobalt.internal.string.CharProperties;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaString;

public class FormatDesc {
    private static final DoubleToStringConverter.Symbols LOWER_SYMBOLS = new DoubleToStringConverter.Symbols("inf", "nan", 101, 'x', 'p', 'a');
    private static final DoubleToStringConverter.Symbols UPPER_SYMBOLS = new DoubleToStringConverter.Symbols("INF", "NAN", 69, 'X', 'P', 'A');
    static final DoubleToStringConverter.FormatOptions DEFAULT_LOWER_OPTIONS = new DoubleToStringConverter.FormatOptions(LOWER_SYMBOLS, false, false, false, -1, false, false);
    private static final int MAX_FLAGS = 5;
    static final int LEFT_ADJUST = 1;
    static final int EXPLICIT_PLUS = 2;
    static final int SPACE = 4;
    static final int ALTERNATE_FORM = 8;
    static final int ZERO_PAD = 16;
    static final int PRECISION = 32;
    private final int flags;
    private final int width;
    private final int precision;
    final int conversion;
    final LuaString format;
    final int start;
    final int length;

    FormatDesc(LuaString format, int start) throws LuaError {
        this.format = format;
        this.start = start;
        int p = start;
        int n = format.length();
        int c = 0;
        int flags = 0;
        boolean moreFlags = true;
        block7: while (moreFlags) {
            c = p < n ? format.charAt(p++) : 0;
            switch (c) {
                case 45: {
                    flags |= 1;
                    continue block7;
                }
                case 43: {
                    flags |= 2;
                    continue block7;
                }
                case 32: {
                    flags |= 4;
                    continue block7;
                }
                case 35: {
                    flags |= 8;
                    continue block7;
                }
                case 48: {
                    flags |= 0x10;
                    continue block7;
                }
            }
            moreFlags = false;
        }
        if (p - start - 1 > 5) {
            throw new LuaError("invalid format (repeated flags)");
        }
        int width = -1;
        if (CharProperties.isDigit(c)) {
            width = c - 48;
            int n2 = c = p < n ? format.charAt(p++) : 0;
            if (CharProperties.isDigit(c)) {
                width = width * 10 + c - 48;
                c = p < n ? format.charAt(p++) : 0;
            }
        }
        this.width = width;
        int precision = -1;
        if (c == 46) {
            int n3 = c = p < n ? format.charAt(p++) : 0;
            if (CharProperties.isDigit(c)) {
                precision = c - 48;
                int n4 = c = p < n ? format.charAt(p++) : 0;
                if (CharProperties.isDigit(c)) {
                    precision = precision * 10 + c - 48;
                    c = p < n ? format.charAt(p++) : 0;
                }
            } else {
                precision = 0;
            }
            flags |= 0x20;
        }
        this.precision = precision;
        this.flags = flags;
        if (CharProperties.isDigit(c)) {
            throw new LuaError("invalid format (width or precision too long)");
        }
        this.conversion = c;
        this.length = p - start;
    }

    private boolean leftAdjust() {
        return (this.flags & 1) != 0;
    }

    private boolean alternateForm() {
        return (this.flags & 8) != 0;
    }

    private boolean zeroPad() {
        return (this.flags & 0x11) == 16;
    }

    private boolean explicitPlus() {
        return (this.flags & 2) != 0;
    }

    private boolean space() {
        return (this.flags & 6) == 4;
    }

    public static FormatDesc ofUnsafe(String format) {
        try {
            return new FormatDesc(LuaString.valueOf(format), 0);
        }
        catch (LuaError e) {
            throw new IllegalStateException(e);
        }
    }

    void checkFlags(int flags) throws LuaError {
        if ((this.flags & ~flags) == 0) {
            return;
        }
        Buffer buffer = new Buffer();
        buffer.append("invalid conversion specification: '%");
        buffer.append(this.format, this.start, this.length);
        buffer.append("'");
        throw new LuaError(buffer.toLuaString());
    }

    void format(Buffer buf, byte c) {
        int nSpaces;
        int n = nSpaces = this.width > 1 ? this.width - 1 : 0;
        if (!this.leftAdjust()) {
            FormatDesc.pad(buf, ' ', nSpaces);
        }
        buf.append(c);
        if (this.leftAdjust()) {
            FormatDesc.pad(buf, ' ', nSpaces);
        }
    }

    public void format(Buffer buf, long number) {
        int nSpaces;
        int minWidth;
        String digits;
        boolean hasSign = false;
        switch (this.conversion) {
            case 120: {
                digits = Long.toHexString(number);
                break;
            }
            case 88: {
                digits = Long.toHexString(number).toUpperCase();
                break;
            }
            case 111: {
                digits = Long.toOctalString(number);
                break;
            }
            case 117: {
                digits = Long.toUnsignedString(number);
                break;
            }
            default: {
                digits = Long.toString(number);
                hasSign = true;
            }
        }
        if (!(number != 0L || this.precision != 0 || this.conversion == 111 && this.alternateForm())) {
            digits = "";
        }
        int nDigits = minWidth = digits.length();
        if (hasSign) {
            if (number < 0L) {
                --nDigits;
                digits = digits.substring(1);
            } else if (this.explicitPlus() || this.space()) {
                ++minWidth;
            }
        }
        String prefix = "";
        if (number != 0L && this.alternateForm()) {
            switch (this.conversion) {
                case 120: {
                    prefix = "0x";
                    break;
                }
                case 88: {
                    prefix = "0X";
                    break;
                }
                case 111: {
                    prefix = "0";
                    ++nDigits;
                }
            }
            minWidth += prefix.length();
        }
        int nZeros = this.precision > nDigits ? this.precision - nDigits : (this.precision == -1 && this.zeroPad() && this.width > minWidth ? this.width - minWidth : 0);
        int n = nSpaces = this.width > (minWidth += nZeros) ? this.width - minWidth : 0;
        if (!this.leftAdjust()) {
            FormatDesc.pad(buf, ' ', nSpaces);
        }
        if (hasSign) {
            if (number < 0L) {
                buf.append('-');
            } else if (this.explicitPlus()) {
                buf.append('+');
            } else if (this.space()) {
                buf.append(' ');
            }
        }
        buf.append(prefix);
        if (nZeros > 0) {
            FormatDesc.pad(buf, '0', nZeros);
        }
        buf.append(digits);
        if (this.leftAdjust()) {
            FormatDesc.pad(buf, ' ', nSpaces);
        }
    }

    public void format(Buffer buf, double number) {
        int prec = this.precision;
        switch (this.conversion) {
            case 71: 
            case 103: {
                int computedPrecision = switch (prec) {
                    case -1 -> 6;
                    case 0 -> 1;
                    default -> prec;
                };
                DoubleToStringConverter.toPrecision(number, computedPrecision, this.doubleOpts(this.conversion == 71), buf);
                break;
            }
            case 69: 
            case 101: {
                DoubleToStringConverter.toExponential(number, prec == -1 ? 6 : prec, this.doubleOpts(this.conversion == 69), buf);
                break;
            }
            case 65: 
            case 97: {
                DoubleToStringConverter.toHex(number, prec, this.doubleOpts(this.conversion == 65), buf);
                break;
            }
            case 102: {
                DoubleToStringConverter.toFixed(number, prec == -1 ? 6 : prec, this.doubleOpts(false), buf);
            }
        }
    }

    void format(Buffer buf, LuaString s) {
        int minWidth;
        int nSpaces;
        if (this.precision == -1 && s.length() >= 100) {
            buf.append(s);
            return;
        }
        int nullIndex = s.indexOf((byte)0);
        if (nullIndex != -1) {
            s = s.substringOfEnd(0, nullIndex);
        }
        if (this.precision >= 0 && s.length() > this.precision) {
            s = s.substringOfEnd(0, this.precision);
        }
        int n = nSpaces = this.width > (minWidth = s.length()) ? this.width - minWidth : 0;
        if (!this.leftAdjust()) {
            FormatDesc.pad(buf, ' ', nSpaces);
        }
        buf.append(s);
        if (this.leftAdjust()) {
            FormatDesc.pad(buf, ' ', nSpaces);
        }
    }

    private static void pad(Buffer buf, char c, int n) {
        byte b = (byte)c;
        while (n-- > 0) {
            buf.append(b);
        }
    }

    private DoubleToStringConverter.FormatOptions doubleOpts(boolean caps) {
        return new DoubleToStringConverter.FormatOptions(caps ? UPPER_SYMBOLS : LOWER_SYMBOLS, this.explicitPlus(), this.space(), this.alternateForm(), this.width, this.zeroPad(), this.leftAdjust());
    }
}

